import { ChainId } from '@uniswap/sdk-core';
import { nativeOnChain, WRAPPED_NATIVE_CURRENCY } from '../util';
import { ARB_ARBITRUM, BTC_BNB, BUSD_BNB, CELO, CEUR_CELO, CUSD_CELO, DAI_ARBITRUM, DAI_AVAX, DAI_BNB, DAI_CELO, DAI_MAINNET, DAI_MOONBEAM, DAI_OPTIMISM, DAI_UNICHAIN, ETH_BNB, OP_OPTIMISM, USDB_BLAST, USDCE_ZKSYNC, USDC_ARBITRUM, USDC_AVAX, USDC_BASE, USDC_BASE_SEPOLIA, USDC_BNB, USDC_MAINNET, USDC_MOONBEAM, USDC_NATIVE_ARBITRUM, USDC_OPTIMISM, USDC_POLYGON, USDC_SONEIUM, USDC_UNICHAIN, USDC_UNICHAIN_SEPOLIA, USDC_WORLDCHAIN, USDC_ZKSYNC, USDT_ARBITRUM, USDT_BNB, USDT_MAINNET, USDT_MONAD_TESTNET, USDT_OPTIMISM, WBTC_ARBITRUM, WBTC_MAINNET, WBTC_MOONBEAM, WBTC_OPTIMISM, WBTC_WORLDCHAIN, WETH_POLYGON, WLD_WORLDCHAIN, WMATIC_POLYGON, WSTETH_MAINNET, } from './token-provider';
export const BASES_TO_CHECK_TRADES_AGAINST = {
    [ChainId.MAINNET]: [
        nativeOnChain(ChainId.MAINNET),
        WRAPPED_NATIVE_CURRENCY[ChainId.MAINNET],
        DAI_MAINNET,
        USDC_MAINNET,
        USDT_MAINNET,
        WBTC_MAINNET,
        WSTETH_MAINNET,
    ],
    [ChainId.GOERLI]: [WRAPPED_NATIVE_CURRENCY[ChainId.GOERLI]],
    [ChainId.SEPOLIA]: [
        nativeOnChain(ChainId.SEPOLIA),
        WRAPPED_NATIVE_CURRENCY[ChainId.SEPOLIA],
    ],
    //v2 not deployed on [arbitrum, polygon, celo, gnosis, moonbeam, bnb, avalanche] and their testnets
    [ChainId.OPTIMISM]: [
        nativeOnChain(ChainId.OPTIMISM),
        WRAPPED_NATIVE_CURRENCY[ChainId.OPTIMISM],
        USDC_OPTIMISM,
        DAI_OPTIMISM,
        USDT_OPTIMISM,
        WBTC_OPTIMISM,
        OP_OPTIMISM,
    ],
    [ChainId.ARBITRUM_ONE]: [
        nativeOnChain(ChainId.ARBITRUM_ONE),
        WRAPPED_NATIVE_CURRENCY[ChainId.ARBITRUM_ONE],
        WBTC_ARBITRUM,
        DAI_ARBITRUM,
        USDC_ARBITRUM,
        USDC_NATIVE_ARBITRUM,
        USDT_ARBITRUM,
        ARB_ARBITRUM,
    ],
    [ChainId.ARBITRUM_GOERLI]: [],
    [ChainId.ARBITRUM_SEPOLIA]: [],
    [ChainId.OPTIMISM_GOERLI]: [],
    [ChainId.OPTIMISM_SEPOLIA]: [],
    [ChainId.POLYGON]: [
        nativeOnChain(ChainId.POLYGON),
        USDC_POLYGON,
        WETH_POLYGON,
        WMATIC_POLYGON,
    ],
    [ChainId.POLYGON_MUMBAI]: [],
    [ChainId.CELO]: [CELO, CUSD_CELO, CEUR_CELO, DAI_CELO],
    [ChainId.CELO_ALFAJORES]: [],
    [ChainId.GNOSIS]: [],
    [ChainId.MOONBEAM]: [
        WRAPPED_NATIVE_CURRENCY[ChainId.MOONBEAM],
        DAI_MOONBEAM,
        USDC_MOONBEAM,
        WBTC_MOONBEAM,
    ],
    [ChainId.BNB]: [
        nativeOnChain(ChainId.BNB),
        WRAPPED_NATIVE_CURRENCY[ChainId.BNB],
        BUSD_BNB,
        DAI_BNB,
        USDC_BNB,
        USDT_BNB,
        BTC_BNB,
        ETH_BNB,
    ],
    [ChainId.AVALANCHE]: [
        WRAPPED_NATIVE_CURRENCY[ChainId.AVALANCHE],
        USDC_AVAX,
        DAI_AVAX,
    ],
    [ChainId.BASE_GOERLI]: [],
    [ChainId.BASE]: [
        nativeOnChain(ChainId.BASE),
        WRAPPED_NATIVE_CURRENCY[ChainId.BASE],
        USDC_BASE,
    ],
    [ChainId.ZORA]: [
        nativeOnChain(ChainId.ZORA),
        WRAPPED_NATIVE_CURRENCY[ChainId.ZORA],
    ],
    [ChainId.ZORA_SEPOLIA]: [WRAPPED_NATIVE_CURRENCY[ChainId.ZORA_SEPOLIA]],
    [ChainId.ROOTSTOCK]: [WRAPPED_NATIVE_CURRENCY[ChainId.ROOTSTOCK]],
    [ChainId.BLAST]: [
        nativeOnChain(ChainId.BLAST),
        WRAPPED_NATIVE_CURRENCY[ChainId.BLAST],
        USDB_BLAST,
    ],
    [ChainId.ZKSYNC]: [
        WRAPPED_NATIVE_CURRENCY[ChainId.ZKSYNC],
        USDCE_ZKSYNC,
        USDC_ZKSYNC,
    ],
    [ChainId.WORLDCHAIN]: [
        nativeOnChain(ChainId.WORLDCHAIN),
        WRAPPED_NATIVE_CURRENCY[ChainId.WORLDCHAIN],
        USDC_WORLDCHAIN,
        WLD_WORLDCHAIN,
        WBTC_WORLDCHAIN,
    ],
    [ChainId.UNICHAIN_SEPOLIA]: [
        nativeOnChain(ChainId.UNICHAIN_SEPOLIA),
        WRAPPED_NATIVE_CURRENCY[ChainId.UNICHAIN_SEPOLIA],
        USDC_UNICHAIN_SEPOLIA,
    ],
    [ChainId.UNICHAIN]: [
        nativeOnChain(ChainId.UNICHAIN),
        WRAPPED_NATIVE_CURRENCY[ChainId.UNICHAIN],
        DAI_UNICHAIN,
        USDC_UNICHAIN,
    ],
    [ChainId.BASE_SEPOLIA]: [
        nativeOnChain(ChainId.BASE_SEPOLIA),
        WRAPPED_NATIVE_CURRENCY[ChainId.BASE_SEPOLIA],
        USDC_BASE_SEPOLIA,
    ],
    [ChainId.MONAD_TESTNET]: [
        nativeOnChain(ChainId.MONAD_TESTNET),
        WRAPPED_NATIVE_CURRENCY[ChainId.MONAD_TESTNET],
        USDT_MONAD_TESTNET,
    ],
    [ChainId.SONEIUM]: [
        nativeOnChain(ChainId.SONEIUM),
        WRAPPED_NATIVE_CURRENCY[ChainId.SONEIUM],
        USDC_SONEIUM,
    ],
};
export class CachingSubgraphProvider {
    /**
     * Creates an instance of CachingV3SubgraphProvider.
     * @param chainId The chain id to use.
     * @param subgraphProvider The provider to use to get the subgraph pools when not in the cache.
     * @param cache Cache instance to hold cached pools.
     * @param protocol Subgraph protocol version
     */
    constructor(chainId, subgraphProvider, cache, protocol) {
        this.chainId = chainId;
        this.subgraphProvider = subgraphProvider;
        this.cache = cache;
        this.protocol = protocol;
        this.SUBGRAPH_KEY = (chainId) => `subgraph-pools-${this.protocol}-${chainId}`;
    }
    async getPools() {
        const cachedPools = await this.cache.get(this.SUBGRAPH_KEY(this.chainId));
        if (cachedPools) {
            return cachedPools;
        }
        const pools = await this.subgraphProvider.getPools();
        await this.cache.set(this.SUBGRAPH_KEY(this.chainId), pools);
        return pools;
    }
}
//# sourceMappingURL=data:application/json;base64,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